<?php

// Define database connection parameters
$servername = "localhost";
$username = "root"; // Default XAMPP username
$password = "";     // Default XAMPP password
$dbname = "registration_db"; // Replace with your database name

// Create a new mysqli connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Function to fetch and return data as a PHP array, retrieving ALL columns
function fetchData($conn, $indexNumber = null) {
    if ($indexNumber) {
        // Use a prepared statement to search for a specific index number
        $sql = "SELECT * FROM registrations WHERE indexNumber = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $indexNumber);
        $stmt->execute();
        $result = $stmt->get_result();
    } else {
        // Fetch all data if no index number is specified
        $sql = "SELECT * FROM registrations ORDER BY submission_time DESC";
        $result = $conn->query($sql);
    }
    
    $data = [];
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
    }
    return $data;
}

// Check if the user wants to download a CSV file
if (isset($_GET['download']) && $_GET['download'] === 'true') {
    // Fetch all data
    $data = fetchData($conn);

    if (empty($data)) {
        echo "No data to download.";
        exit();
    }

    // Set headers for CSV download
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="registrations.csv"');
    
    // Create a file pointer connected to the output stream
    $output = fopen('php://output', 'w');
    
    // Get the keys from the first row to use as CSV headers
    fputcsv($output, array_keys($data[0]));
    
    // Loop through the data and output each row
    foreach ($data as $row) {
        fputcsv($output, $row);
    }
    
    // Close the file pointer
    fclose($output);
    exit();
} else {
    // Otherwise, fetch and return data as JSON for the web page
    header('Content-Type: application/json');
    $indexNumber = isset($_GET['indexNumber']) ? $_GET['indexNumber'] : null;
    $data = fetchData($conn, $indexNumber);

    if ($data) {
        echo json_encode(["success" => true, "data" => $data]);
    } else {
        echo json_encode(["success" => true, "data" => [], "message" => "No records found."]);
    }
}

// Close the database connection
$conn->close();

?>
