<?php

header('Content-Type: application/json');

// Define database connection parameters
$servername = "localhost";
$username = "root"; // Default XAMPP username
$password = "";     // Default XAMPP password
$dbname = "registration_db"; // Replace with your database name

// Create a new mysqli connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    // If connection fails, return a JSON error message
    http_response_code(500); // Set HTTP status code to 500
    echo json_encode(["success" => false, "message" => "Connection failed: " . $conn->connect_error]);
    exit();
}

// Check if the request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Sanitize and validate input data
    // Using `isset` to prevent warnings if a field is missing
    $fullName       = $_POST['fullName'] ?? '';
    $phoneNumber    = $_POST['phoneNumber'] ?? '';
    $indexNumber    = $_POST['indexNumber'] ?? '';
    $examType       = $_POST['examType'] ?? '';
    $examYear       = $_POST['examYear'] ?? '';
    $dateOfBirth    = $_POST['dateOfBirth'] ?? '';
    $serialNumber   = $_POST['serialNumber'] ?? '';
    $pin            = $_POST['pin'] ?? '';

    // SQL INSERT statement using a prepared statement to prevent SQL injection
    $sql = "INSERT INTO registrations (fullName, phoneNumber, indexNumber, examType, examYear, dateOfBirth, serialNumber, pin) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    // Prepare the statement
    $stmt = $conn->prepare($sql);

    if ($stmt === false) {
        http_response_code(500);
        echo json_encode(["success" => false, "message" => "Failed to prepare statement: " . $conn->error]);
        exit();
    }

    // Bind parameters to the statement. 'ssssssss' indicates all parameters are strings.
    $stmt->bind_param("ssssssss", $fullName, $phoneNumber, $indexNumber, $examType, $examYear, $dateOfBirth, $serialNumber, $pin);

    // Execute the statement
    if ($stmt->execute()) {
        // Return a JSON success message
        echo json_encode(["success" => true, "message" => "Form submitted successfully!"]);
    } else {
        // Return a JSON error message
        echo json_encode(["success" => false, "message" => "Error: " . $stmt->error]);
    }

    // Close the statement
    $stmt->close();

} else {
    // If the request is not POST, return an error
    http_response_code(405); // Method Not Allowed
    echo json_encode(["success" => false, "message" => "Invalid request method."]);
}

// Close the database connection
$conn->close();

?>
